<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Payment Failed</title>
<style>
    body {
        margin: 0;
        font-family: Arial, sans-serif;
        background: #f6f7fb;
        display: flex;
        justify-content: center;
        align-items: center;
        height: 100vh;
    }
    .card {
        background: #fff;
        padding: 30px 40px;
        border-radius: 15px;
        text-align: center;
        width: 350px;
        box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        animation: fadeIn .8s ease-in-out;
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px);}
        to { opacity: 1; transform: translateY(0);}
    }

    .circle {
        width: 120px;
        height: 120px;
        background: #ffebeb;
        border-radius: 50%;
        display: flex;
        justify-content: center;
        align-items: center;
        margin: auto;
        position: relative;
        animation: bounce 1s infinite alternate ease-in-out;
    }

    @keyframes bounce {
        0% { transform: scale(1); }
        100% { transform: scale(1.05); }
    }

    .cross {
        width: 70px;
        height: 70px;
        position: relative;
    }

    .cross:before,
    .cross:after {
        content: '';
        position: absolute;
        top: 0;
        left: 50%;
        width: 10px;
        height: 100%;
        background: #e60000;
        border-radius: 10px;
    }

    .cross:before {
        transform: translateX(-50%) rotate(45deg);
    }

    .cross:after {
        transform: translateX(-50%) rotate(-45deg);
    }

    h2 {
        color: #e60000;
        font-size: 28px;
        margin-top: 20px;
    }

    p {
        color: #444;
        font-size: 15px;
        margin-bottom: 20px;
    }

    a.btn {
        text-decoration: none;
        background: #e60000;
        color: #fff;
        padding: 12px 20px;
        border-radius: 8px;
        display: inline-block;
        font-weight: 600;
        transition: .3s;
    }

    a.btn:hover {
        background: #b30000;
    }
</style>
</head>
<body>

<div class="card">
    <div class="circle">
        <div class="cross"></div>
    </div>
    <h2>Payment Failed</h2>
    <p>Unfortunately, your payment did not go through. Please try again later.</p>

    <a class="btn" href="index.php">Go to Home</a>
</div>

<script>
    // Prevent back button navigation to this page
    history.pushState(null, null, location.href);
    window.onpopstate = function () {
        history.go(1);
    };
</script>

</body>
</html>
